unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, EIDLIBCTRLLib_TLB, StdCtrls, ExtCtrls, jpeg;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FEID: TEIDlib;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
 lHandler: Integer;
begin
  FEID := TEIDlib.Create(self);
  FEID.Init('', 0, 0, lHandler);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FEID.Exit;
  FreeAndNil(FEID);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
 lMap: IMapCollection;
 lCert: ICertifCheck;
 lPicture: Pointer;
 lStream: TMemoryStream;
 lPictureVar: OleVariant;
 lJPEG: TJPEGImage;
begin
  FEID.GetID(lMap, lCert);
  if lMap = nil then
    ShowMessage('Impossible de lire la carte')
  else
  begin
    self.Memo1.Lines.Add('Nom: '+lMap.GetValue('Name'));
    self.Memo1.Lines.Add('Nationalit: '+lMap.GetValue('Nationality'));
    self.Memo1.Lines.Add('Date de naissance: '+lMap.GetValue('BirthDate'));

    FEID.GetPicture(lMap, lCert);
    lPictureVar := lMap.GetValue('Picture');
    lPicture := VarArrayLock(lPictureVar);
    lStream := TMemoryStream.Create;
    try
      lStream.Write(lPicture^, VarArrayHighBound(lPictureVar, 1) - VarArrayLowBound(lPictureVar, 1) + 1);
      VarArrayUnlock(lPictureVar);
      lStream.Position := 0;

      lJPEG := TJPEGImage.Create;
      try
        lJPEG.LoadFromStream(lStream);
        Image1.Picture.Assign(lJPEG);
      finally
        FreeAndNil(lJPEG);
      end;
    finally
      FreeAndNil(lStream);
    end;
  end;
end;

end.
